//	Maze4DApp.swift
//
//	© 2025 by Jeff Weeks
//	See TermsOfUse.txt

import SwiftUI


@main
struct Maze4DApp: App {

	init() {

		//	Create a fallback set of user defaults (the "factory settings").
		//	These will get used if and only if the user has not provided his/her own values.
		UserDefaults.standard.register(defaults: ["sound effects" : true])

		//	Initialize the audio.
#if os(iOS)
		setUpAudio()
#endif
	}

	var body: some Scene {

#if os(iOS)
		WindowGroup {
			Maze4DContentView()
		}
#endif
#if os(macOS)

		let theTestWindowSize = CGSize(width: 512.0, height: 512.0)
		let theTestContentSize = NSWindow.contentRect(
									forFrameRect: NSRect(
													origin: .zero,
													size: theTestWindowSize),
									styleMask: .titled)
		let theTitleBarHeight = theTestWindowSize.height - theTestContentSize.height

		WindowGroup {
			Maze4DContentView()
		}
		//	Request a window size that gives a square content area
		//	after allowing space for the title bar.
		//	(Exception: Screenshots must be rectangular.)
		.defaultSize(
			width:  gMakeScreenshots ? 1280.0 : 680.0,
			height: gMakeScreenshots ?  800.0 : 680.0 + theTitleBarHeight)

#endif
	}
}
